import java.util.ArrayList;
import java.util.List;

public class Aluno extends Pessoa {
    private int ra;
    private String curso;
    private List<Disciplina> disciplinas = new ArrayList<>();
    
    public Aluno(String cpf, String nome, int ra, String curso) {
        super(cpf, nome);
        this.ra = ra;
        this.curso = curso;
    }

    public void addDisciplina(Disciplina disciplina) {
        disciplinas.add(disciplina);
    }

    public int getRa() {
        return ra;
    }

    public String getCurso() {
        return curso;
    }

    public void setRa(int ra) {
        this.ra = ra;
    }

    public void setCurso(String curso) {
        this.curso = curso;
    }

    @Override
    public String toString() {
        String ds = "[";
        for (Disciplina d : disciplinas) {
            ds += d.getNome() + ", ";
        }
        ds += "]";
        return "Aluno{cpf=" + getCpf() + ", nome=" + getNome() + ", ra=" + ra + ", curso=" + curso + ", disciplinas=" + ds + "}";
    }
}
