import java.util.ArrayList;
import java.util.List;

public class Professor extends Pessoa {
    private String titulo;
    private float salario;
    private List<Disciplina> disciplinas = new ArrayList<>();

    public Professor(String cpf, String nome, String titulo, float salario) {
        super(cpf, nome);
        this.titulo = titulo;
        this.salario = salario;
    }

    public void addDisciplina(Disciplina disciplina) {
        disciplinas.add(disciplina);
    }

    public String getTitulo() {
        return titulo;
    }

    public float getSalario() {
        return salario;
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
    } 

    public void setSalario(float salario) {
        this.salario = salario;
    }

    @Override
    public String toString() {
        String ds = "[";
        for (Disciplina d : disciplinas) {
            ds += d.getNome() + ", ";
        }
        ds += "]";
        return "Professor{cpf=" + getCpf() + ", nome=" + getNome() + ", titulo=" + titulo + ", salario=" + salario + ", disciplinas=" + ds + "}";
    }
}
